/**********************************************************
*
* .do file to create output for Dickson/Gordon/Huber
* "Enforcement and Compliance in an Uncertain World: An Experimental Investigation"
*
*
**********************************************************/

set more off
set memory 256m
graph set ps logo off

log using ReplicationOutput\EnforcementAndCompliance.log, text replace

**************************
**************************
* CREATE FIGURES 1 and 2 *
**************************
**************************

************************************
* Create panel A of figures 1 and 2
************************************

clear
use RoleA_aggregated.dta

gen exp=""
replace exp="FP" if experiment_description=="T1 0.4 T2 0.0"
replace exp="FN" if experiment_description=="T1 0.0 T2 0.4"
replace exp="TCFP" if experiment_description=="Chose T1 0.4 T2 0.0 and bribe over no error"
replace exp="AS" if experiment_description=="T1 0.0 T2 0.0"
replace exp="TCAS" if experiment_description=="Chose No error"

sort period exp
collapse (mean) binary_contibuted, by(period exp)

rename binary_contibuted CONTRATE

*twoway (line CONTRATE period if exp=="AS", xtitle("Period") ylabel(0(.2)1, grid) ytitle("Contribution Rate") lcolor(black) lpattern(solid) ) (line CONTRATE period if exp=="TCAS", lcolor(black) lpattern(dash) ), title("A: Average group contribution levels by period", size(medium)) scheme(s1mono) legend(label(1 "No Errors") label(2 "Tech. Choice No Errors"))

#delimit ;

twoway
(line CONTRATE period if exp=="FP", 
xtitle("Period") ylabel(0(.2)1, grid) ytitle("Contribution Rate") lcolor(black) lpattern(solid) )
(line CONTRATE period if exp=="FN", lcolor(black) lpattern(dash) )
(line CONTRATE period if exp=="AS", lcolor(black) lpattern(dash_dot) )
, title("A: Average group contribution levels by period", size(medium)) legend(off) scheme(s1mono) name(F1PA);

*, legend(label(1 "False Positives") label(2 "False Negatives")) scheme(s1mono) name(F1PA);

twoway
(line CONTRATE period if exp=="FP", 
xtitle("Period") ylabel(0(.2)1, grid) ytitle("Contribution Rate") lcolor(black) lpattern(solid) )
(line CONTRATE period if exp=="TCFP", lcolor(black) lpattern(dot) )
(line CONTRATE period if exp=="TCAS", lcolor(black) lpattern(shortdash) )
, title("A: Average group contribution levels by period", size(medium)) legend(off) scheme(s1mono) name(F2PA);

*, legend(label(1 "False Negatives") label(2 "False Positives")) scheme(s1mono) name(F2PA);

#delimit cr

************************************
* Create panel B of figures 1 and 2
************************************

clear
use RoleA_aggregated.dta

gen exp=""
replace exp="FP" if experiment_description=="T1 0.4 T2 0.0"
replace exp="FN" if experiment_description=="T1 0.0 T2 0.4"
replace exp="TCFP" if experiment_description=="Chose T1 0.4 T2 0.0 and bribe over no error"
replace exp="AS" if experiment_description=="T1 0.0 T2 0.0"
replace exp="TCAS" if experiment_description=="Chose No error"

replace P_given_S=. if  signal_cheated==0
replace P_given_NS=. if  signal_cheated==1

sort exp group

collapse (mean) P_given_S P_given_NS  binary_contibuted, by(exp group)

rename binary_contibuted CONTRATE
gen PATSRATE=P_given_S-P_given_NS

regress CONTRATE PATSRATE if exp=="FP", robust
regress CONTRATE PATSRATE if exp=="FN", robust
regress CONTRATE PATSRATE if exp=="TCFP", robust
regress CONTRATE PATSRATE if exp=="AS", robust

gen TCFP=(exp=="TCFP")
gen FN=(exp=="FN")
gen TCFP_PATSRATE=PATSRATE*TCFP
gen FN_PATSRATE=PATSRATE*FN

regress CONTRATE PATSRATE FN_PATSRATE FN if exp=="FP" | exp=="FN", robust
regress CONTRATE PATSRATE TCFP TCFP_PATSRATE if (exp=="FP" | exp=="TCFP"), robust
regress CONTRATE PATSRATE TCFP TCFP_PATSRATE if (exp=="FN" | exp=="TCFP"), robust
regress CONTRATE PATSRATE TCFP FN TCFP_PATSRATE, robust

*twoway (lfit CONTRATE PATSRATE if exp=="AS", lcolor(black) lpattern(solid) ylabel(0(.2)1) xlabel(0(.2)1) xtitle("Freq. (Punish|Accusatory) - Freq. (Punish|Exculpatory)") ytitle("Contribution Rate")) (lfit CONTRATE PATSRATE if exp=="TCAS", lcolor(black) lpattern(dash)) (scatter CONTRATE PATSRATE if exp=="AS" | exp=="TCAS", msymbol(none) mlabel(exp) mlabsize(vsmall) mlabcolor(black) mlabposition(0))

#delimit ;

twoway 
(lfit CONTRATE PATSRATE if exp=="FP",
lcolor(black) lpattern(solid) ylabel(0(.2)1) xlabel(0(.2)1)
xtitle("Freq. (Punish|Accusatory) - Freq. (Punish|Exculpatory)")
ytitle("Contribution Rate")
legend(off))
(lfit CONTRATE PATSRATE if exp=="FN", lcolor(black) lpattern(dash))
(lfit CONTRATE PATSRATE if exp=="AS", lcolor(black) lpattern(dash_dot))
(scatter CONTRATE PATSRATE if exp=="FN" | exp=="FP" | exp=="AS", msymbol(none) mlabel(exp) mlabsize(vsmall) mlabcolor(black) mlabposition(0))

, title("B: Monitor Strategies and Group Contribution Rates", size(medium)) scheme(s1mono) name(F1PB)
;

*legend(size(small) cols(2) title("Linear regression for...", size(medsmall)) label(1 "False Pos.") label(2 "False Neg.") label(3 "")));

twoway 
(lfit CONTRATE PATSRATE if exp=="FP",
lcolor(black) lpattern(solid) ylabel(0(.2)1) xlabel(0(.2)1)
xtitle("Freq. (Punish|Accusatory) - Freq. (Punish|Exculpatory)")
ytitle("Contribution Rate")
legend(off))
(lfit CONTRATE PATSRATE if exp=="TCFP", lcolor(black) lpattern(dot))
(lfit CONTRATE PATSRATE if exp=="TCAS", lcolor(black) lpattern(shortdash))
(scatter CONTRATE PATSRATE if exp=="FP" | exp=="TCFP" | exp=="TCAS", msymbol(none) mlabel(exp) mlabsize(vsmall) mlabcolor(black) mlabposition(0))

, title("B: Monitor Strategies and Group Contribution Rates", size(medium)) scheme(s1mono)  name(F2PB)
;

*legend(size(small) cols(2) title("Linear regression for...", size(medsmall)) label(1 "False Pos.") label(2 "Tech. Choice False Pos.") label(3 "")));

#delimit cr

************************************
* Create panel C of figures 1 and 2
************************************

clear
use RoleA_aggregated.dta

gen exp=""
replace exp="FP" if experiment_description=="T1 0.4 T2 0.0"
replace exp="FN" if experiment_description=="T1 0.0 T2 0.4"
replace exp="TCFP" if experiment_description=="Chose T1 0.4 T2 0.0 and bribe over no error"
replace exp="AS" if experiment_description=="T1 0.0 T2 0.0"
replace exp="TCAS" if experiment_description=="Chose No error"

gen ERRORRATE=0
replace ERRORRATE=1 if binary_punished==binary_contibuted

sort group exp
collapse (mean) binary_contibuted ERRORRATE, by(group exp)

rename binary_contibuted CONTRATE

#delimit ;

twoway 
(lfit CONTRATE ERRORRATE if exp=="FP",
lcolor(black) lpattern(solid) ylabel(0(.2)1) xlabel(0(.1).6)
xtitle("Overall Punishment Error Rate")
ytitle("Contribution Rate")
legend(size(small) cols(3) order(1 2 3) label(1 "False Pos.") label(2 "False Neg.") label(3 "Accurate Signals")))
(lfit CONTRATE ERRORRATE if exp=="FN", lcolor(black) lpattern(dash))
(lfit CONTRATE ERRORRATE if exp=="AS", lcolor(black) lpattern(dash_dot))
(scatter CONTRATE ERRORRATE if exp=="FN" | exp=="FP" | exp=="AS", msymbol(none) mlabel(exp) mlabsize(vsmall) mlabcolor(black) mlabposition(0))

, title("C: Error Rates and Group Contribution Rates", size(medium)) scheme(s1mono) name(F1PC)
;

*legend(size(small) cols(2) title("Linear regression for...", size(medsmall)) label(1 "False Pos.") label(2 "False Neg.") label(3 "")));

twoway 
(lfit CONTRATE ERRORRATE if exp=="FP",
lcolor(black) lpattern(solid) ylabel(0(.2)1) xlabel(0(.1).6)
xtitle("Overall Punishment Error Rate")
ytitle("Contribution Rate")
legend(size(small) cols(3) order(1 2 3) label(1 "False Pos.") label(2 "Tech. Choice False Pos.") label(3 "Tech. Choice Accurate Signals")))
(lfit CONTRATE ERRORRATE if exp=="TCFP", lcolor(black) lpattern(dot))
(lfit CONTRATE ERRORRATE if exp=="TCAS", lcolor(black) lpattern(shortdash))
(scatter CONTRATE ERRORRATE if exp=="TCFP" | exp=="FP" | exp=="TCAS", msymbol(none) mlabel(exp) mlabsize(vsmall) mlabcolor(black) mlabposition(0))

, title("C: Error Rates and Group Contribution Rates", size(medium)) scheme(s1mono) name(F2PC)
;

*legend(size(small) cols(2) title("Linear regression for...", size(medsmall)) label(1 "False Pos.") label(2 "Tech. Choice False Pos.") label(3 "")));

#delimit cr

gen TCFP=(exp=="TCFP")
gen FN=(exp=="FN")
gen TCFP_ERRORRATE=ERRORRATE*TCFP
gen FN_ERRORRATE=ERRORRATE*FN

regress CONTRATE ERRORRATE if exp=="FP", robust

regress CONTRATE ERRORRATE if exp=="FN", robust

regress CONTRATE ERRORRATE if exp=="TCFP", robust

regress CONTRATE ERRORRATE FN_ERRORRATE FN if exp=="FP" | exp=="FN", robust
regress CONTRATE ERRORRATE TCFP_ERRORRATE TCFP if exp=="FP" | exp=="TCFP", robust

************************************
* Combine graphs to create unified figures 1 and 2
************************************

*graph set ps tmargin .5
*graph set ps lmargin 1.75

graph set ps tmargin 0
graph set ps lmargin 1.25
graph set ps pagesize custom
graph set ps pageheight 11
graph set ps pagewidth 8.5

graph combine F1PA F1PB F1PC, colfirst cols(1) imargin(small) note("Note: Lines in panel A are average by period. Lines in panels B and C are for linear regressions, by group.", size(vsmall)) scheme(s1mono) xsize(6) ysize(11) scale(.75)
graph export ReplicationOutput\Figure1.ps, replace

graph combine F2PA F2PB F2PC, colfirst cols(1) imargin(small) note("Note: Lines in panel A are average by period. Lines in panels B and C are for linear regressions, by group.", size(vsmall)) scheme(s1mono) xsize(6) ysize(11) scale(.75)
graph export ReplicationOutput\Figure2.ps, replace

**************************
**************************
* CREATE TABLES          *
**************************
**************************

************************************
* Appendix Table 1, summary punishment and contribution rates by treatment
************************************

clear
use RoleA_aggregated.dta

gen exp=""
replace exp="False Positives Treatment" if experiment_description=="T1 0.4 T2 0.0"
replace exp="False Negatives Treatment" if experiment_description=="T1 0.0 T2 0.4"
replace exp="Technology Choice False Positives Treatment" if experiment_description=="Chose T1 0.4 T2 0.0 and bribe over no error"
replace exp="Technology Choice No Errors Treatment" if experiment_description=="Chose No error"
replace exp="No Errors Treatment" if experiment_description=="T1 0.0 T2 0.0"

replace P_given_S=. if  signal_cheated==0
replace P_given_NS=. if  signal_cheated==1

collapse (mean) P_given_S P_given_NS binary_contibuted, by(exp group)

rename binary_contibuted CONTRATE
gen PATSRATE=P_given_S-P_given_NS

gen AS=exp=="No Errors Treatment"
gen P_AS=AS*PATSRATE
regress CONTRATE PATSRATE if AS==1
regress CONTRATE PATSRATE if AS==1 | exp=="False Negatives"
regress CONTRATE PATSRATE AS P_AS if AS==1 | exp=="False Negatives"

drop group

order exp P_given_S P_given_NS PATSRATE CONTRATE
keep exp P_given_S P_given_NS PATSRATE CONTRATE

outsheet using ReplicationOutput\AppendixTable1.out, replace

************************************
* Summary statistics of contributions, overall and by period
************************************

clear
use RoleA_aggregated.dta

gen exp=""
replace exp="FP" if experiment_description=="T1 0.4 T2 0.0"
replace exp="FN" if experiment_description=="T1 0.0 T2 0.4"
replace exp="TCFP" if experiment_description=="Chose T1 0.4 T2 0.0 and bribe over no error"

sort exp group period
collapse (sum) binary_contibuted, by(exp group period)
rename binary_contibuted TOTALCONT

gen fpvfn=.
replace fpvfn=0 if exp=="FP"
replace fpvfn=1 if exp=="FN"

gen fpvtcfp=.
replace fpvtcfp=0 if exp=="FP"
replace fpvtcfp=1 if exp=="TCFP"

*Contributions, false positives versus false negatives
bysort period: ttest TOTALCONT, by(fpvfn) unequal
bysort period: ranksum TOTALCONT, by(fpvfn) 

ttest TOTALCONT, by(fpvfn) unequal
ranksum TOTALCONT, by(fpvfn) 

table period fpvfn, c(mean TOTALCONT)
table fpvfn, c(mean TOTALCONT)

*Contributions, false positives versus technology choice false positives
bysort period: ttest TOTALCONT, by(fpvtcfp) unequal
bysort period: ranksum TOTALCONT, by(fpvtcfp) 

ttest TOTALCONT, by(fpvtcfp) unequal
ranksum TOTALCONT, by(fpvtcfp) 

table period fpvtcfp, c(mean TOTALCONT)
table fpvtcfp, c(mean TOTALCONT)

************************************
* Summary statistics of error rates and punishment behavior
************************************

clear
use RoleA_aggregated.dta

gen exp=""
replace exp="FP" if experiment_description=="T1 0.4 T2 0.0"
replace exp="FN" if experiment_description=="T1 0.0 T2 0.4"
replace exp="TCFP" if experiment_description=="Chose T1 0.4 T2 0.0 and bribe over no error"

replace P_given_S=. if  signal_cheated==0
replace P_given_NS=. if  signal_cheated==1

gen wrongful_punishment=.
replace wrongful_punishment=0 if (binary_contibuted==1 & binary_punished==0)
replace wrongful_punishment=1 if (binary_contibuted==1 & binary_punished==1)

gen got_away_with_cheating=.
replace got_away_with_cheating=0 if (binary_contibuted==0 & binary_punished==1)
replace got_away_with_cheating=1 if (binary_contibuted==0 & binary_punished==0)

gen eitherpunishmenterror=(binary_contibuted==1 & binary_punished==1) | (binary_contibuted==0 & binary_punished==0)

sort exp group period
collapse (mean) P_given_S P_given_NS wrongful_punishment got_away_with_cheating eitherpunishmenterror, by(exp group period)

gen fpvfn=.
replace fpvfn=0 if exp=="FP"
replace fpvfn=1 if exp=="FN"

gen fpvtcfp=.
replace fpvtcfp=0 if exp=="FP"
replace fpvtcfp=1 if exp=="TCFP"

*punishment behavior. note this analysis is aggregating to period/group level (averages within period and group)
table exp if period==1, c(mean P_given_S mean P_given_NS) 
ttest P_given_S if period==1, by(fpvfn) unequal
ttest P_given_NS if period==1, by(fpvfn) unequal
ttest P_given_S if period==1, by(fpvtcfp) unequal
ttest P_given_NS if period==1, by(fpvtcfp) unequal

table exp, c(mean P_given_S mean P_given_NS)
ttest P_given_S, by(fpvfn) unequal
ttest P_given_NS, by(fpvfn) unequal
ttest P_given_S, by(fpvtcfp) unequal
ttest P_given_NS, by(fpvtcfp) unequal

*punishment behavior. note this analysis is aggregating to period/group level (averages within period and group)
table exp if period==1, c(mean wrongful_punishment mean got_away_with_cheating mean eitherpunishmenterror) 
ttest wrongful_punishment if period==1, by(fpvfn) unequal
ttest got_away_with_cheating if period==1, by(fpvfn) unequal
ttest eitherpunishmenterror if period==1, by(fpvfn) unequal
ttest wrongful_punishment if period==1, by(fpvtcfp) unequal
ttest got_away_with_cheating if period==1, by(fpvtcfp) unequal
ttest eitherpunishmenterror if period==1, by(fpvtcfp) unequal

table exp, c(mean wrongful_punishment mean got_away_with_cheating mean eitherpunishmenterror) 
ttest wrongful_punishment, by(fpvfn) unequal
ttest got_away_with_cheating, by(fpvfn) unequal
ttest eitherpunishmenterror, by(fpvfn) unequal
ttest wrongful_punishment, by(fpvtcfp) unequal
ttest got_away_with_cheating, by(fpvtcfp) unequal
ttest eitherpunishmenterror, by(fpvtcfp) unequal

************************************
* Statistical analysis of enforcement decision effects on compliance
************************************

clear
use RoleB_aggregated.dta

gen exp=""
replace exp="FP" if experiment_description=="T1 0.4 T2 0.0"
replace exp="FN" if experiment_description=="T1 0.0 T2 0.4"
replace exp="TCFP" if experiment_description=="Chose T1 0.4 T2 0.0 and bribe over no error"

*generate unique group id
egen uniqueid=group(exp group subject)

quietly tab period, gen(pdum_)
drop pdum_1 pdum_2

gen lag_binaryothercont=lag_othercontributions/20
tab lag_binaryothercont, gen(lag_othercontdum_)
drop lag_othercontdum_1

gen fpvfn=.
replace fpvfn=0 if exp=="FP"
replace fpvfn=1 if exp=="FN"

gen fpvtcfp=.
replace fpvtcfp=0 if exp=="FP"
replace fpvtcfp=1 if exp=="TCFP"

gen lag_binavgtotalcontributions=lag_avgtotalcontributions/20

*FALSE POSITIVES
logit binarycontribution lag_wrongly_punished lag_gotaway_withcheating lag_binarycontribution lag_othercontdum_* pdum_* if exp=="FP", robust
outreg using ReplicationOutput\Table2.csv, comma bracket se tdec(3) bdec(3) ctitle("FP Robust SE") replace

*marginal effect of getting away with cheating rather than being punished
lincom lag_gotaway_withcheating
*marginal effect of being wrongly punished rather than uneventfully complying
lincom lag_wrongly_punished
*which is worse? conditional on not having complied, getting away with cheating or, conditional on having complied, being falsely punished?
lincom lag_gotaway_withcheating-lag_wrongly_punished

test pdum_3 pdum_4 pdum_5 pdum_6 pdum_7  pdum_8 pdum_9 pdum_10 pdum_11  pdum_12 pdum_13 pdum_14 pdum_15 pdum_16 pdum_17 pdum_18 pdum_19 pdum_20
mfx, varlist(lag_binarycontribution) at(zero lag_othercontdum_2=1)
mfx, varlist(lag_othercontdum_3) at(zero)
mfx, varlist(lag_wrongly_punished) at(zero lag_othercontdum_2=1 lag_binarycontribution=1)
mfx, varlist(lag_gotaway_withcheating ) at(zero lag_othercontdum_2=1 lag_binarycontribution=0)

xtmelogit binarycontribution lag_wrongly_punished lag_gotaway_withcheating lag_binarycontribution lag_othercontdum_* pdum_* if exp=="FP" || group: || uniqueid:
*outreg chokes on this, so have to enter results manually into table
*outreg using ReplicationOutput\Table2.csv, comma bracket se tdec(3) bdec(3) ctitle("FP Random group and individual effects") append

*marginal effect of getting away with cheating rather than being punished
lincom lag_gotaway_withcheating
*marginal effect of being wrongly punished rather than uneventfully complying
lincom lag_wrongly_punished
*which is worse? conditional on not having complied, getting away with cheating or, conditional on having complied, being falsely punished?
lincom lag_gotaway_withcheating-lag_wrongly_punished

*For appendix, with historical average
logit binarycontribution lag_wrongly_punished lag_gotaway_withcheating lag_binarycontribution lag_binavgtotalcontributions lag_othercontdum_* pdum_* if exp=="FP", robust
outreg using ReplicationOutput\AppendixTable2.csv, comma bracket se tdec(3) bdec(3) ctitle("FP Robust SE") replace

*FALSE NEGATIVES
logit binarycontribution lag_wrongly_punished lag_gotaway_withcheating lag_binarycontribution lag_othercontdum_* pdum_* if exp=="FN", robust
outreg using ReplicationOutput\Table2.csv, comma bracket se tdec(3) bdec(3) ctitle("FN Robust SE") append

*marginal effect of getting away with cheating rather than being punished
lincom lag_gotaway_withcheating
*marginal effect of being wrongly punished rather than uneventfully complying
lincom lag_wrongly_punished
*which is worse? conditional on not having complied, getting away with cheating or, conditional on having complied, being falsely punished?
lincom lag_gotaway_withcheating-lag_wrongly_punished

test pdum_3 pdum_4 pdum_5 pdum_6 pdum_7  pdum_8 pdum_9 pdum_10 pdum_11  pdum_12 pdum_13 pdum_14 pdum_15 pdum_16 pdum_17 pdum_18 pdum_19 pdum_20
mfx, varlist(lag_binarycontribution) at(zero lag_othercontdum_2=1)
mfx, varlist(lag_othercontdum_3) at(zero)
mfx, varlist(lag_wrongly_punished) at(zero lag_othercontdum_2=1 lag_binarycontribution=1)
mfx, varlist(lag_gotaway_withcheating ) at(zero lag_othercontdum_2=1 lag_binarycontribution=0)

xtmelogit binarycontribution lag_wrongly_punished lag_gotaway_withcheating lag_binarycontribution lag_othercontdum_* pdum_* if exp=="FN" || group: || uniqueid:
*outreg chokes on this, so have to enter results manually into table
*outreg using ReplicationOutput\Table2.csv, comma bracket se tdec(3) bdec(3) ctitle("FN Random group and individual effects") append

*marginal effect of getting away with cheating rather than being punished
lincom lag_gotaway_withcheating
*marginal effect of being wrongly punished rather than uneventfully complying
lincom lag_wrongly_punished
*which is worse? conditional on not having complied, getting away with cheating or, conditional on having complied, being falsely punished?
lincom lag_gotaway_withcheating-lag_wrongly_punished

*For appendix, with historical average
logit binarycontribution lag_wrongly_punished lag_gotaway_withcheating lag_binarycontribution lag_binavgtotalcontributions lag_othercontdum_* pdum_* if exp=="FN", robust
outreg using ReplicationOutput\AppendixTable2.csv, comma bracket se tdec(3) bdec(3) ctitle("FN Robust SE") append

*POOLED ANALYSIS, FP VS FN
gen fn_lag_wrongly_punished=fpvfn*lag_wrongly_punished
gen fn_lag_gotaway_withcheating=fpvfn*lag_gotaway_withcheating

logit binarycontribution lag_wrongly_punished fn_lag_wrongly_punished lag_gotaway_withcheating fn_lag_gotaway_withcheating lag_binarycontribution fpvfn lag_othercontdum_* pdum_*, robust
outreg using ReplicationOutput\Table2.csv, comma bracket se tdec(3) bdec(3) ctitle("Pooled FP FN Robust SE") append

test fn_lag_wrongly_punished
test fn_lag_gotaway_withcheating

*TCFP 
logit binarycontribution lag_wrongly_punished lag_gotaway_withcheating lag_binarycontribution lag_othercontdum_* pdum_* if exp=="TCFP", robust
outreg using ReplicationOutput\Table2.csv, comma bracket se tdec(3) bdec(3) ctitle("TCFP Robust SE") append

*marginal effect of getting away with cheating rather than being punished
lincom lag_gotaway_withcheating
*marginal effect of being wrongly punished rather than uneventfully complying
lincom lag_wrongly_punished
*which is worse? conditional on not having complied, getting away with cheating or, conditional on having complied, being falsely punished?
lincom lag_gotaway_withcheating-lag_wrongly_punished

test pdum_3 pdum_4 pdum_5 pdum_6 pdum_7  pdum_8 pdum_9 pdum_10 pdum_11  pdum_12 pdum_13 pdum_14 pdum_15 pdum_16 pdum_17 pdum_18 pdum_19 pdum_20
mfx, varlist(lag_binarycontribution) at(zero lag_othercontdum_2=1)
mfx, varlist(lag_othercontdum_3) at(zero)
mfx, varlist(lag_wrongly_punished) at(zero lag_othercontdum_2=1 lag_binarycontribution=1)
mfx, varlist(lag_gotaway_withcheating ) at(zero lag_othercontdum_2=1 lag_binarycontribution=0)

xtmelogit binarycontribution lag_wrongly_punished lag_gotaway_withcheating lag_binarycontribution lag_othercontdum_* pdum_* if exp=="TCFP" || group: || uniqueid:
*outreg chokes on this, so need to do it manually
*outreg using ReplicationOutput\Table2.csv, comma bracket se tdec(3) bdec(3) ctitle("TCFP Random group and individual effects") append

*marginal effect of getting away with cheating rather than being punished
lincom lag_gotaway_withcheating
*marginal effect of being wrongly punished rather than uneventfully complying
lincom lag_wrongly_punished
*which is worse? conditional on not having complied, getting away with cheating or, conditional on having complied, being falsely punished?
lincom lag_gotaway_withcheating-lag_wrongly_punished

*For appendix, with historical average
logit binarycontribution lag_wrongly_punished lag_gotaway_withcheating lag_binarycontribution lag_binavgtotalcontributions lag_othercontdum_* pdum_* if exp=="TCFP", robust
outreg using ReplicationOutput\AppendixTable2.csv, comma bracket se tdec(3) bdec(3) ctitle("TCFP robust SE") append

*POOLED ANALYSIS, FP VS TCFP
gen tcfp_lag_wrongly_punished=fpvtcfp*lag_wrongly_punished
gen tcfp_lag_gotaway_withcheating=fpvtcfp*lag_gotaway_withcheating

logit binarycontribution lag_wrongly_punished tcfp_lag_wrongly_punished lag_gotaway_withcheating tcfp_lag_gotaway_withcheating lag_binarycontribution fpvtcfp lag_othercontdum_* pdum_*, robust
outreg using ReplicationOutput\Table2.csv, comma bracket se tdec(3) bdec(3) ctitle("Pooled FP TCFP Robust SE") append

test tcfp_lag_wrongly_punished
test tcfp_lag_gotaway_withcheating

log close
