/*******************************************************************
** Figure3.do								      **
** Recreates Figure 3 in Dickson, Gordon, and Huber (2009)		**
** Input: RoleB_aggregated.dta					      **
** Output: Figure3.log (log file); Figure3.ps (postscript		**
** graphic of Figure)							      **
** Final Revision: April 23, 2009						**
*******************************************************************/							

#delimit; 
clear;
set mem 500m;
set more off;
set matsize 5000;
set seed 10242004;
capture log close;
log using "ReplicationOutput\Figure3.log", replace;

use "RoleB_aggregated.dta";
keep if substr(experiment_description,1,15)=="Chose T1 0.4 T2"| experiment_description == "T1 0.4 T2 0.0";
generate exogenous = experiment_description == "T1 0.4 T2 0.0";
gen exog_wrong  = lag_wrongly_punished*(exogenous == 1);
gen exog_gotaway= lag_gotaway*(exogenous == 1);
tab period, gen(pdum_);
drop pdum_1-pdum_2;
gen lag_binaryothercontributions=lag_othercontributions /20;
tab lag_binaryothercontributions, gen(lag_othercontdum_);
drop lag_othercontdum_1;
gen lag_binaryavgtotalcontributions=lag_avgtotalcontributions/20;
egen uniqueid=group(group subject);
/*******Is Pulling the Trigger Worthwhile? ENDOGENOUS False Positive Treatments******/
/*Number of simulated draws of beta_hat, probabilities, and test statistic */
global simsize = 3000;
if $simsize>_N{;
	set obs $simsize;
};

/*Vectors of independent variables associated with different outcomes 
x_ab_c means x given 
	ab=wp: wrongful punishment
	ab=wn: wrongful nonpunishment
	ab=cp: correct punishment 
	ab=cn: correct nonpunishment;
	c= 0 others contributed, 1 other contributed, etc.
*/

matrix x_wp_0 = (1\0\1\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wp_1 = (1\0\1\1\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wp_2 = (1\0\1\0\1\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wp_3 = (1\0\1\0\0\1\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);

matrix x_wn_0 = (0\1\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wn_1 = (0\1\0\1\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wn_2 = (0\1\0\0\1\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wn_3 = (0\1\0\0\0\1\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);

matrix x_cp_0 = (0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cp_1 = (0\0\0\1\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cp_2 = (0\0\0\0\1\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cp_3 = (0\0\0\0\0\1\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);

matrix x_cn_0 = (0\0\1\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cn_1 = (0\0\1\1\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cn_2 = (0\0\1\0\1\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cn_3 = (0\0\1\0\0\1\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);

/*Hypothesis Test Using Multivel Random Effects Logit */

#delimit;
xtmelogit binarycontribution lag_wrongly_punished lag_gotaway_withcheating lag_binarycontribution 
lag_othercontdum_* pdum_* if exogenous == 0 || group: || uniqueid: ;
/*Acquire system matrices */
#delimit;
matrix b = get(_b);
matrix VCE = get(VCE);

#delimit;
/*Draw $simsize betahat vectors */
drawnorm b1-b27, means(b) cov(VCE);
mkmat b1-b25 in 1/$simsize, matrix(betasim);
drop b1-b27;
scalar j_s = 100;
matrix stat = J($simsize,1,0);
matrix results = J(j_s,5,0);
#delimit;
local j = 1;
while `j' <= j_s {;
	scalar theta_s = `j'/j_s;
	/*Prior beliefs theta should map into how many others contribute*/
	qui gen sim_oth = (uniform()<theta_s)+( uniform()<theta_s)+( uniform()<theta_s) in 1/$simsize;
	mkmat sim_oth in 1/$simsize, matrix(sim_oth);
	qui drop sim_oth;
	local i = 1;
	while `i' <= $simsize {;
		if sim_oth[`i',1] == 0 {;
			matrix x_wp = x_wp_0;		
			matrix x_wn = x_wn_0;
			matrix x_cp = x_cp_0;
			matrix x_cn = x_cn_0;
		};
		else if sim_oth[`i',1]== 1 {;
			matrix x_wp = x_wp_1;		
			matrix x_wn = x_wn_1;
			matrix x_cp = x_cp_1;
			matrix x_cn = x_cn_1;
		};
		else if sim_oth[`i',1]== 2 {;
			matrix x_wp = x_wp_2;		
			matrix x_wn = x_wn_2;
			matrix x_cp = x_cp_2;
			matrix x_cn = x_cn_2;
		};
		else {;
			matrix x_wp = x_wp_3;		
			matrix x_wn = x_wn_3;
			matrix x_cp = x_cp_3;
			matrix x_cn = x_cn_3;
		};
		/*Linear indices associated with different punishment/contribution experiences*/
		matrix xb_wp = betasim[`i',1..25]*x_wp;
 		matrix xb_wn = betasim[`i',1..25]*x_wn;
		matrix xb_cp = betasim[`i',1..25]*x_cp;
		matrix xb_cn = betasim[`i',1..25]*x_cn;
		/*Logit transformed probabilities of linear indices*/
		scalar p_wp_s = 1/(1+exp(-xb_wp[1,1]));
		scalar p_wn_s = 1/(1+exp(-xb_wn[1,1]));
		scalar p_cp_s = 1/(1+exp(-xb_cp[1,1]));
		scalar p_cn_s = 1/(1+exp(-xb_cn[1,1]));
		/*Using probabilities and theta, calculate test statistic */
		scalar stat_s = 0.4*theta_s*(p_wp_s-p_cn_s)+(1-theta_s)*(p_cp_s-p_wn_s);
		matrix stat[`i',1]= stat_s;
		local i = `i' + 1;
	};
	/*Save Results*/
	svmat stat;
	qui count if stat1 > 0 & stat1 !=.;
	scalar pg0 = r(N)/$simsize;
	matrix results[`j',1]=theta_s;
	matrix results[`j',2]=pg0;
	qui summarize stat1, detail;
	scalar meanstat = r(mean);
	matrix results[`j',3]=meanstat;
	qui centile stat1, centile(2.5 97.5);
	matrix results[`j',4]=r(c_1);
	matrix results[`j',5]=r(c_2);
	qui drop stat1;
	local j = `j'+1;
};
svmat results;
rename results1 theta_mre_tcfp;
label var theta_mre_tcfp "Prior Pr(Contribute)";
rename results2 pvalue_mre_tcfp;
label var pvalue_mre_tcfp "Specification (2)";
rename results3 meanstat_mre_tcfp;
rename results4 stat2p5_mre_tcfp;
rename results5 stat97p5_mre_tcfp;

/*******Is Pulling the Trigger Worthwhile? EXOGENOUS False Positive Treatments******/

/*Number of simulated draws of beta_hat, probabilities, and test statistic */
global simsize = 3000;
if $simsize>_N{;
	set obs $simsize;
};

/*Vectors of independent variables associated with different outcomes 
x_ab_c means x given 
	ab=wp: wrongful punishment
	ab=wn: wrongful nonpunishment
	ab=cp: correct punishment 
	ab=cn: correct nonpunishment;
	c= 0 others contributed, 1 other contributed, etc.
*/

matrix x_wp_0 = (1\0\1\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wp_1 = (1\0\1\1\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wp_2 = (1\0\1\0\1\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wp_3 = (1\0\1\0\0\1\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);

matrix x_wn_0 = (0\1\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wn_1 = (0\1\0\1\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wn_2 = (0\1\0\0\1\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_wn_3 = (0\1\0\0\0\1\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);

matrix x_cp_0 = (0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cp_1 = (0\0\0\1\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cp_2 = (0\0\0\0\1\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cp_3 = (0\0\0\0\0\1\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);

matrix x_cn_0 = (0\0\1\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cn_1 = (0\0\1\1\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cn_2 = (0\0\1\0\1\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);
matrix x_cn_3 = (0\0\1\0\0\1\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\1);

/*Hypothesis Test Using Multivel Random Effects Logit */
#delimit;
xtmelogit binarycontribution lag_wrongly_punished lag_gotaway_withcheating lag_binarycontribution 
lag_othercontdum_* pdum_* if exogenous==1|| group: || uniqueid: ;
/*Acquire system matrices */

matrix b = get(_b);
matrix VCE = get(VCE);

#delimit;
/*Draw $simsize betahat vectors */
drawnorm b1-b27, means(b) cov(VCE);
mkmat b1-b25 in 1/$simsize, matrix(betasim);
drop b1-b27;
scalar j_s = 100;
matrix stat = J($simsize,1,0);
matrix results = J(j_s,5,0);
#delimit;
local j = 1;
while `j' <= j_s {;
	scalar theta_s = `j'/j_s;
	/*Prior beliefs theta should map into how many others contribute*/
	qui gen sim_oth = (uniform()<theta_s)+( uniform()<theta_s)+( uniform()<theta_s) in 1/$simsize;
	mkmat sim_oth in 1/$simsize, matrix(sim_oth);
	qui drop sim_oth;
	local i = 1;
	while `i' <= $simsize {;
		if sim_oth[`i',1] == 0 {;
			matrix x_wp = x_wp_0;		
			matrix x_wn = x_wn_0;
			matrix x_cp = x_cp_0;
			matrix x_cn = x_cn_0;
		};
		else if sim_oth[`i',1]== 1 {;
			matrix x_wp = x_wp_1;		
			matrix x_wn = x_wn_1;
			matrix x_cp = x_cp_1;
			matrix x_cn = x_cn_1;
		};
		else if sim_oth[`i',1]== 2 {;
			matrix x_wp = x_wp_2;		
			matrix x_wn = x_wn_2;
			matrix x_cp = x_cp_2;
			matrix x_cn = x_cn_2;
		};
		else {;
			matrix x_wp = x_wp_3;		
			matrix x_wn = x_wn_3;
			matrix x_cp = x_cp_3;
			matrix x_cn = x_cn_3;
		};
		/*Linear indices associated with different punishment/contribution experiences*/
		matrix xb_wp = betasim[`i',1..25]*x_wp;
 		matrix xb_wn = betasim[`i',1..25]*x_wn;
		matrix xb_cp = betasim[`i',1..25]*x_cp;
		matrix xb_cn = betasim[`i',1..25]*x_cn;
		/*Logit transformed probabilities of linear indices*/
		scalar p_wp_s = 1/(1+exp(-xb_wp[1,1]));
		scalar p_wn_s = 1/(1+exp(-xb_wn[1,1]));
		scalar p_cp_s = 1/(1+exp(-xb_cp[1,1]));
		scalar p_cn_s = 1/(1+exp(-xb_cn[1,1]));
		/*Using probabilities and theta, calculate test statistic */
		scalar stat_s = 0.4*theta_s*(p_wp_s-p_cn_s)+(1-theta_s)*(p_cp_s-p_wn_s);
		matrix stat[`i',1]= stat_s;
		local i = `i' + 1;
	};
	/*Save Results*/
	svmat stat;
	qui count if stat1 > 0 & stat1 !=.;
	scalar pg0 = r(N)/$simsize;
	matrix results[`j',1]=theta_s;
	matrix results[`j',2]=pg0;
	qui summarize stat1, detail;
	scalar meanstat = r(mean);
	matrix results[`j',3]=meanstat;
	qui centile stat1, centile(2.5 97.5);
	matrix results[`j',4]=r(c_1);
	matrix results[`j',5]=r(c_2);
	qui drop stat1;
	local j = `j'+1;
};
svmat results;
rename results1 theta_mre_xfp;


label var theta_mre_xfp "Prior Pr(Contribute)";
rename results2 pvalue_mre_xfp;
label var pvalue_mre_xfp "Specification (2)";
rename results3 meanstat_mre_xfp;
rename results4 stat2p5_mre_xfp;
rename results5 stat97p5_mre_xfp;


gen zero = 0;

#delimit;
rename theta_mre_xfp theta;

label var pvalue_mre_xfp "False Positives";
label var pvalue_mre_tcfp "Technology Choice False Positives";
twoway (line pvalue_mre_xfp theta, sort lcolor(black) lpattern(solid)) (line pvalue_mre_tcfp theta, lcolor(black) lpattern(dot)), 
	ytitle(Pr(Punishment Beneficial)) xtitle(Prior Pr(Contribute))
	yline(0.5,lcolor(black)) graphregion(margin(zero) fcolor(white) lcolor(white)) scheme(s1mono);
graph export "ReplicationOutput\figure3.ps", as(ps) logo(off)  replace;


log close;



