#delimit;
clear;
set mem 100m;
cd "C:\Documents and Settings\Sanford Gordon\My Documents\research\primary\Data\echo";
capture log close;
log using "doppler_analysis.log", replace;

use raw_echo.dta;
replace lalength = 2.6 if lalength == 26; /*Corrects coding error*/
label var laatip "LAA Apex (cm./sec)";
label var laaos  "LAA Os";
gen mean = (laatip+laaos)/2;
label var mean "1/2(LAA Os + LAA Apex)";
gen difference = laaos-laatip;
label var difference "Difference";
gen ratio = laaos/laatip;
label var ratio "Ratio (LAA Os/LAA Apex)";
gen male = gender == "M";

gen ef=real(substr(lvef,1,2));

/**********************************************************************************
** Descriptive Statistics and Tests                                              **
**********************************************************************************/

/*Summarize data*/
summ laatip laaos difference ratio mean;
centile laatip laaos difference ratio mean;

/*Bivariate correlation between measures */
pwcorr laaos laatip;

/* Conduct Wilcoxon's Sign Rank Test and t-test of Data*/
signrank laaos=laatip;
ttest laaos=laatip;

/*This just creates separate variables for laaos and laatip, allowing us to label them differently in the graph */
gen afos = laaos*(af==1);
replace afos = . if afos ==0 ;
gen sros = laaos*(af==0);
replace sros = . if sros == 0;
label variable afos "Atrial Fib.";
label var sros "Sinus Rhythm";

/*Create a dummy observation so that our 45 degree line extends all the way to the origin*/
scalar n = _N;
local np2 = n+2;
set obs `np2';
local n = _N-1;
replace laatip = 0 in `n';
local n = _N;
replace laatip = 100 in `n';

/*Generate Ratio and logratio measures*/
gen srratio = ratio*(af==0);
replace srratio = . if srratio == 0;
gen afratio = ratio*(af==1);
replace afratio = . if afratio == 0;
label var afratio "Atrial Fib.";
label var srratio "Sinus Rhythm";
gen logsrratio  = log(srratio);
label var logsrratio "Sinus Rhythm";
gen logafratio = log(afratio);
label var logafratio "Atrial Fib.";
gen loggeomean = 0.5*log(laaos*laatip);
label var loggeomean "1/2 Log(Orifice*Apex)";

gen logratio = log(ratio);
summ logratio;
scalar logratio_mean = r(mean);
scalar logratio_sd = r(sd);
scalar N  = r(N);
scalar logratio_se = sqrt(logratio_sd^2/N);
scalar logratio_hi = logratio_mean + 1.96*logratio_se;
scalar logratio_lo = logratio_mean - 1.96*logratio_se;

/*Create dummy observations so our representation of the mean logratio and confidence interval extends across the graph */
local n=_N;
local nm1 = `n'-1;
replace loggeomean = 3 in `nm1';
replace loggeomean = 5 in `n';
gen logratiohi = logratio_hi;
gen logratiolo = logratio_lo;
gen logratiomean = logratio_mean;


/*Conduct LAD Regression as Descriptive Measure and construct 95% confidence intervals*/
qreg laaos laatip;
/*This is a test of whether the coefficient on laatip is significantly different from one */
lincom laatip-1;

predict oshat, xb;
predict stdos, stdp;
gen os_low = oshat-1.96*stdos;
gen os_hi = oshat+1.96*stdos;

/**********************************************************************************
** Smoothed Histogram of Ratio                                                   **
**********************************************************************************/ 
qui summ ratio, detail;
local c = r(p50);
twoway (kdensity ratio, lcolor(black)),
       ytitle(Density,color(black)) ylabel(,nogrid) xtitle("Ratio (LAA Os/LAA Apex)") 
	 xlabel(1(0.5)3) legend(off)
	 xline(`c', lcolor(black))
	 text(1.45 1.65 "Median = 1.44")
       graphregion(margin(small) fcolor(white) lcolor(white))
	 title("Smoothed Histogram of Ratio (LAA Os/LAA Apex)", color(black)) nodraw
	 saving(density, replace);


/**********************************************************************************
** Main Scatterplot with LAD regression line and 95% confidence interval         **
**********************************************************************************/ 
#delimit ;
twoway (rarea os_low os_hi laatip, sort fcolor(gs1)  fintensity(inten20) lcolor(white) lwidth(none)) 
       (scatter afos laatip, mcolor(black) msymbol(circle_hollow)) 
       (scatter sros laatip, mcolor(black) msymbol(circle)) 
       (line laatip laatip, sort lcolor(black)) 
       (line oshat laatip, sort lwidth(thin) lcolor(black) lpattern(dash)), 
	 ytitle("LAA Orifice (cm./sec)") ylabel(0(25)150, nogrid) xtitle("LAA Apex (cm./sec)") xlabel(0(10)100) legend(order(2 3))
	 graphregion(margin(small) fcolor(white) lcolor(white))
	 title(B. Scatterplot with LAD Regression Line, color(black)) nodraw
	 saving(scatter, replace);

/**********************************************************************************
** Ratio-Intensity Plot Using Base 10 Logarithms                                 **
**********************************************************************************/ 


#delimit;
twoway (rarea logratiolo logratiohi loggeomean, sort fcolor(gs1)  fintensity(inten20) lcolor(white) lwidth(none))  
	 (scatter logafratio loggeomean, mcolor(black) msymbol(circle_hollow)) 
       (scatter logsrratio loggeomean, mcolor(black) msymbol(circle))
       (line logratiomean loggeomean, sort lwidth(thin) lcolor(black) lpattern(dash)),
         yline(0, lcolor(black)) ytitle("Log(Orifice/Apex)") ylabel(-1(0.25)1, nogrid) xlabel(3(0.25)5) legend(off)
   	   graphregion(margin(small) fcolor(white) lcolor(white)) 
	   title(A. Ratio-Intensity Plot, color(black)) nodraw 
	   saving(RIPlot, replace);

reg logratio loggeomean;
reg logratio loggeomean male age af cva endocarditis heartrate laalength lalength ef, robust;
reg logratio male age af cva endocarditis heartrate laalength lalength ef, robust;

reg difference mean male age af cva endocarditis heartrate laalength lalength ef, robust;
reg difference male age af cva endocarditis heartrate laalength lalength ef, robust;

/*Combine graphs*/
#delimit;
graph combine RIplot.gph scatter.gph, cols(1) xsize(6) ysize(9) graphregion(margin(small) fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) saving(2x1, replace);


/*R&R Graphs*/

qreg laaos laalength;
predict oshat1, xb;
label var oshat1 "Predicted Velocity (Os)";
predict ossd1, stdp;
gen oshat1_lo = oshat1-1.96*ossd1;
gen oshat1_hi = oshat1+1.96*ossd1;

qreg laatip laalength;
predict tiphat1, xb;
label var tiphat1 "Predicted Velocity (Apex)";
predict tipsd1, stdp;
gen tiphat1_lo = tiphat1-1.96*tipsd1;
gen tiphat1_hi = tiphat1+1.96*tipsd1;

#delimit;
label var laaos "LAA Orifice";
label var laatip "LAA Apex";
twoway (rarea oshat1_lo oshat1_hi laalength, sort fcolor(gs1) fintensity(inten20) lcolor(white) lwidth(none))
	 (rarea tiphat1_lo tiphat1_hi laalength, sort fcolor(gs1) fintensity(inten20) lcolor(white) lwidth(none))
	 (rspike laatip laaos laalength, sort lcolor(black)) 
	 (scatter laaos laalength, mcolor(black) msymbol(circle))
	 (scatter laatip laalength, mcolor(black) msymbol(circle_hollow))
       (line oshat1 laalength, sort lwidth(thin) lcolor(black) lpattern(solid))
       (line tiphat1 laalength, sort lwidth(thin) lcolor(black) lpattern(dash)),
	 ytitle("Velocity (cm./sec.)") xtitle("LAA Length (cm.)") ylabel(0(25)150, nogrid)
       graphregion(margin(small) fcolor(white) lcolor(white))
	 legend(off)
	 title("A. Velocities given LAA Length", color(black)) saving(LAAplot, replace);

qreg laaos lalength;
predict oshat2, xb;
label var oshat2 "Predicted Velocity (Orifice)";
predict ossd2, stdp;
gen oshat2_lo = oshat2-1.96*ossd2;
gen oshat2_hi = oshat2+1.96*ossd2;

qreg laatip lalength;
predict tiphat2, xb;
label var tiphat2 "Predicted Velocity (Apex)";
predict tipsd2, stdp;
gen tiphat2_lo = tiphat2-1.96*tipsd2;
gen tiphat2_hi = tiphat2+1.96*tipsd2;

#delimit;
twoway (rarea oshat2_lo oshat2_hi lalength, sort fcolor(gs1) fintensity(inten20) lcolor(white) lwidth(none))
	 (rarea tiphat2_lo tiphat2_hi lalength, sort fcolor(gs1) fintensity(inten20) lcolor(white) lwidth(none))
	 (rspike laatip laaos lalength, sort lcolor(black)) 
	 (scatter laaos lalength, mcolor(black) msymbol(circle))
	 (scatter laatip lalength, mcolor(black) msymbol(circle_hollow))
       (line oshat2 lalength, sort lwidth(thin) lcolor(black) lpattern(solid))
       (line tiphat2 lalength, sort lwidth(thin) lcolor(black) lpattern(dash)),
	 ytitle("Velocity (cm./sec.)") xtitle("LA Diameter (cm.)") ylabel(0(25)150, nogrid)
       graphregion(margin(small) fcolor(white) lcolor(white))
	 legend(on order(4 6 5 7))
	 title("B. Velocities given LA Diameter", color(black)) saving(LAplot, replace);

#delimit;
graph combine LAAplot.gph LAplot.gph, cols(1) xsize(6) ysize(9) graphregion(margin(small) fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) saving(veloc, replace);

qreg laaos laalength;
qreg laaos lalength;
qreg laatip laalength;
qreg laatip lalength;


reg laaos laalength;
reg laaos lalength;
reg laatip laalength;
reg laatip lalength;

pwcorr laaos laatip laalength lalength, sig;




log close;








clear;

/*
/* Mean-Difference Plot: This just rotates the scatterplot 45 degrees */
gen afdif = difference if af == 1;
label var afdif "Atrial Fib.";
gen srdif = difference if af == 0;
label var srdif "Sinus Rhythm";
#delimit;
twoway  (scatter afdif mean, mcolor(black) msymbol(circle_hollow)) 
        (scatter srdif mean, mcolor(black) msymbol(circle)),  
         yline(0, lcolor(black)) ytitle("LAA Os - LAA Apex") 
         ylabel(-60(20)60, nogrid) xlabel(0(20)140) legend(off)
   	   graphregion(margin(small) fcolor(white) lcolor(white))
	   title(B. Mean-Difference Plot, color(black)) 
	   saving(meandif, replace);
*/

