/**********************************************************
** Title: 02_AnalyzeTermLimitOpinionEffects.do 
** Date: March 15, 2007
** Authors: Sanford Gordon, Dimitri Landa, Gregory Huber
***********************************************************/
capture log close
set memory 50m
set more off

*Variables: gave_challenger_name (got name) recog_chal (rated versus said didn't recog)

#delimit ;

log using "logs\02_AnalyzeTermLimitOpinionEffects.log", replace;
use data\NAES_ChallengerData_Reduced.dta;

summ 
demfav gopfav relativedemfav alt_relativedemfav offeredname recog_chal
income income_dkna union female age age2 white hispanic religious_attend educ
pid5
incumb_pid5 abspid 
timetrend
ln_dem_fundadv_deminc ln_dem_fundadv_repinc
lnchalexp lnincexp 
dem_fresh gop_fresh
fr
challexperience
currexp
femparty
deminc 
termlaw
incvs_chalpart incumbent_priorvs
incpvs_chalpart incumbent_priorpresvs
lphous_chalpart legperhousemem
legprof_chalpart legprof
istermed
termed
, sep(0);

outsum demfav gopfav relativedemfav alt_relativedemfav offeredname recog_chal
income income_dkna union female age age2 white hispanic religious_attend educ
pid5
incumb_pid5 abspid 
timetrend
ln_dem_fundadv_deminc ln_dem_fundadv_repinc
lnchalexp lnincexp 
dem_fresh gop_fresh
fr
challexperience
currexp
femparty
deminc 
termlaw
incvs_chalpart incumbent_priorvs
incpvs_chalpart incumbent_priorpresvs
lphous_chalpart legperhousemem
legprof_chalpart legprof
istermed
termed
using logs\Table3_outsum.out, replace;

/*Favorability analysis*/

regress relativedemfav
income income_dkna union female age age2 white hispanic religious_attend educ pid5 timetrend 
ln_dem_fundadv_deminc ln_dem_fundadv_repinc dem_fresh gop_fresh challexperience deminc
incvs_chalpart incpvs_chalpart lphous_chalpart legprof_chalpart 
termlaw istermed
, robust cluster(groupid);
outreg using logs\Table4_favorability.out, ctitle(`e(deprvar)') tdec(4) bdec(4) bracket se replace;

regress alt_relativedemfav
income income_dkna union female age age2 white hispanic religious_attend educ pid5 timetrend 
ln_dem_fundadv_deminc ln_dem_fundadv_repinc dem_fresh gop_fresh challexperience deminc
incvs_chalpart incpvs_chalpart lphous_chalpart legprof_chalpart 
termlaw istermed
, robust cluster(groupid);
outreg using logs\Table4_favorability.out, ctitle(`e(deprvar)') tdec(4) bdec(4) bracket se append;

*without prior vote outcomes;
regress alt_relativedemfav
income income_dkna union female age age2 white hispanic religious_attend educ pid5 timetrend 
ln_dem_fundadv_deminc ln_dem_fundadv_repinc dem_fresh gop_fresh challexperience deminc
lphous_chalpart legprof_chalpart termlaw istermed
, robust cluster(groupid);
outreg using logs\Table4_favorability.out, ctitle("Excluding Incumbent Vulnerability") tdec(4) bdec(4) bracket se append;

*Excluding opportunity structure;
regress alt_relativedemfav
income income_dkna union female age age2 white hispanic religious_attend educ pid5 timetrend 
ln_dem_fundadv_deminc ln_dem_fundadv_repinc dem_fresh gop_fresh challexperience deminc
incvs_chalpart incpvs_chalpart
termlaw istermed
, robust cluster(groupid);
outreg using logs\Table4_favorability.out, ctitle("Excluding Opportunity Structure") tdec(4) bdec(4) bracket se append;

*excluding incumbent's spending;
regress alt_relativedemfav
income income_dkna union female age age2 white hispanic religious_attend educ pid5 timetrend 
lnchalexp_chalpart dem_fresh gop_fresh challexperience deminc
incvs_chalpart incpvs_chalpart 
termlaw istermed
, robust cluster(groupid);
outreg using logs\Table4_favorability.out, ctitle("Excluding Incumbents Spending") tdec(4) bdec(4) bracket se append;

*with chal partyxtermed interaction;
gen termlaw_chalpart=termlaw*deminc;
label var termlaw_chalpart "State has Term Limit x Republican Challenger";

regress alt_relativedemfav
income income_dkna union female age age2 white hispanic religious_attend educ pid5 timetrend 
ln_dem_fundadv_deminc ln_dem_fundadv_repinc dem_fresh gop_fresh challexperience deminc
incvs_chalpart incpvs_chalpart lphous_chalpart legprof_chalpart 
termlaw termlaw_chalpart istermed
, robust cluster(groupid);
outreg using logs\Table4_favorability.out, ctitle("State has Term Law X Challenger Party") tdec(4) bdec(4) bracket se append;

regress alt_relativedemfav
income income_dkna union female age age2 white hispanic religious_attend educ pid5 timetrend 
ln_dem_fundadv_deminc ln_dem_fundadv_repinc dem_fresh gop_fresh challexperience deminc
incvs_chalpart incpvs_chalpart lphous_chalpart legprof_chalpart 
termlaw_chalpart istermed
, robust cluster(groupid);
outreg using logs\Table4_favorability.out, ctitle("No Term Law Dummy, State has Term Law X Challenger Party") tdec(4) bdec(4) bracket se append;

*Analysis not included in paper

*excluding all spending;
regress alt_relativedemfav
income income_dkna union female age age2 white hispanic religious_attend educ pid5 timetrend 
dem_fresh gop_fresh challexperience deminc
incvs_chalpart incpvs_chalpart 
termlaw istermed
, robust cluster(groupid);
*outreg using logs\Table4_favorability.out, ctitle("Excluding All Spending") tdec(4) bdec(4) bracket se append;

/*Information acquisition analysis*/

probit offeredname 
income income_dkna union female age age2 white hispanic religious_attend education incumb_pid5 abspid 
timetrend lnchalexp lnincexp fr currexp deminc 
incumbent_priorvs incumbent_priorpresvs legperhousemem legprof termlaw 
termed, robust cluster(groupid);
outreg using logs\Table5_recog.out, ctitle(`e(deprvar)') tdec(4) bdec(4) bracket se replace;
mfx, varlist(termed) at(median);

tab offeredname if e(sample);

probit recog_chal 
income income_dkna union female age age2 white hispanic religious_attend education incumb_pid5 abspid 
timetrend lnchalexp lnincexp fr currexp deminc
incumbent_priorvs incumbent_priorpresvs legperhousemem legprof termlaw 
termed, robust cluster(groupid);
outreg using logs\Table5_recog.out, ctitle(`e(deprvar)') tdec(4) bdec(4) bracket se append;
mfx, varlist(termed) at(median);

tab recog_chal if e(sample);

*without prior vote outcomes;
probit offeredname 
income income_dkna union female age age2 white hispanic religious_attend education incumb_pid5 abspid 
timetrend lnchalexp lnincexp fr currexp deminc 
legperhousemem legprof termlaw 
termed, robust cluster(groupid);
outreg using logs\Table5_recog.out, ctitle("Excluding Incumbent Vulnerability (off. to name)") tdec(4) bdec(4) bracket se append;
mfx, varlist(termed) at(median);

tab offeredname if e(sample);

probit recog_chal 
income income_dkna union female age age2 white hispanic religious_attend education incumb_pid5 abspid 
timetrend lnchalexp lnincexp fr currexp deminc
legperhousemem legprof termlaw 
termed, robust cluster(groupid);
outreg using logs\Table5_recog.out, ctitle("Excluding Incumbent Vulnerability (rated)") tdec(4) bdec(4) bracket se append;
mfx, varlist(termed) at(median);

tab recog_chal if e(sample);

*without opportunity structure;
probit offeredname 
income income_dkna union female age age2 white hispanic religious_attend education incumb_pid5 abspid 
timetrend lnchalexp lnincexp fr currexp deminc 
incumbent_priorvs incumbent_priorpresvs termlaw 
termed, robust cluster(groupid);
outreg using logs\Table5_recog.out, ctitle("Excluding Opportunity Structure (off. to name)") tdec(4) bdec(4) bracket se append;
mfx, varlist(termed) at(median);

tab offeredname if e(sample);

probit recog_chal 
income income_dkna union female age age2 white hispanic religious_attend education incumb_pid5 abspid 
timetrend lnchalexp lnincexp fr currexp deminc
incumbent_priorvs incumbent_priorpresvs termlaw 
termed, robust cluster(groupid);
outreg using logs\Table5_recog.out, ctitle("Excluding Opportunity Structure (rated)") tdec(4) bdec(4) bracket se append;
mfx, varlist(termed) at(median);

tab recog_chal if e(sample);

*without incumbent's spending;
probit offeredname 
income income_dkna union female age age2 white hispanic religious_attend education incumb_pid5 abspid 
timetrend lnchalexp fr currexp deminc 
incumbent_priorvs incumbent_priorpresvs legperhousemem legprof termlaw 
termed, robust cluster(groupid);
outreg using logs\Table5_recog.out, ctitle("Excluding incumbent's spending (off. to name)") tdec(4) bdec(4) bracket se append;
mfx, varlist(termed) at(median);

tab offeredname if e(sample);

probit recog_chal 
income income_dkna union female age age2 white hispanic religious_attend education incumb_pid5 abspid 
timetrend lnchalexp fr currexp deminc
incumbent_priorvs incumbent_priorpresvs legperhousemem legprof termlaw 
termed, robust cluster(groupid);
outreg using logs\Table5_recog.out, ctitle("Excluding incumbent's spending (rated)") tdec(4) bdec(4) bracket se append;
mfx, varlist(termed) at(median);

tab recog_chal if e(sample);

*Analysis not included in paper

*without any spending;
probit offeredname 
income income_dkna union female age age2 white hispanic religious_attend education incumb_pid5 abspid 
timetrend fr currexp deminc 
incumbent_priorvs incumbent_priorpresvs legperhousemem legprof termlaw 
termed, robust cluster(groupid);
*outreg using logs\Table5_recog.out, ctitle("Excluding all spending (off. to name)") tdec(4) bdec(4) bracket se append;
mfx, varlist(termed) at(median);

tab offeredname if e(sample);

probit recog_chal 
income income_dkna union female age age2 white hispanic religious_attend education incumb_pid5 abspid 
timetrend fr currexp deminc
incumbent_priorvs incumbent_priorpresvs legperhousemem legprof termlaw 
termed, robust cluster(groupid);
*outreg using logs\Table5_recog.out, ctitle("Excluding all spending (rated)") tdec(4) bdec(4) bracket se append;
mfx, varlist(termed) at(median);

tab recog_chal if e(sample);

*excluding all demographics except PID;
probit offeredname 
incumb_pid5 abspid 
timetrend lnchalexp lnincexp fr currexp deminc 
incumbent_priorvs incumbent_priorpresvs legperhousemem legprof termlaw 
termed, robust cluster(groupid);
*outreg using logs\Table5_recog.out, ctitle("Excluding all Demographics except PID (off. to name)") tdec(4) bdec(4) bracket se append;
mfx, varlist(termed) at(median);

tab offeredname if e(sample);

probit recog_chal 
incumb_pid5 abspid 
timetrend fr currexp deminc
incumbent_priorvs incumbent_priorpresvs legperhousemem legprof termlaw 
termed, robust cluster(groupid);
*outreg using logs\Table5_recog.out, ctitle("Excluding all Demographics except PID (rated)") tdec(4) bdec(4) bracket se append;
mfx, varlist(termed) at(median);

tab recog_chal if e(sample);

log close;
