/***************************************************************
* Create dataset for matching, QJPS Version
* Authors: Sanford Gordon, Gregory Huber
* Update: February 12, 2007
* Uses:
*    QJPS_activekssentences.dta
*    QJPS_judge_ProxData.dta
*    QJPS_KansasDistrictCharacteristics.dta
*    QJPS_judgeid_sentdate_whetherjudgechallenged.dta
***************************************************************/
clear
#delimit ;
pause on ;
capture log close;
set mem 200m;
set matsize 1000;
set more off;

cd "C:\Documents and Settings\Sanford Gordon\My Documents\research\primary\criminal justice\Trial Judges\Kansas\Matching";
log using "logfiles\QJPS_prepare_data_for_matching.log", replace;

/*************
* LOAD DATA *
*************/

*load sentencing data;
use QJPS_activekssentences.dta;

/************************
* Pre-Process KSC data *
************************/

*Drop murders;
drop if c_dead==1;
drop c_dead;

*Drop offgrid (non-guideline) crimes;
drop if off_non ~= .;

*In the KSC data there is a censoring problem with addcount, such that when addcount=5, counts can be greater than 6; 
*We recode addcount to fix this; 
replace addcount=(counts-1) if addcount==5 & counts>6;

*Create a binary dependent variable which is 1 if any prison time is assigned; 
gen prison=0; 
replace prison=1 if totpris>0;

/****************************
* End Pre-Process KSC data *
****************************/

*merge in electoral proximity data by judgeid and day of sentencing; 
*elecprox is scaled 0 to 1 as described in text; 
*alternative measure discussed in footnote 21 is variable proximity_filingdate; 
rename sentdate day; 
sort judgeid day; 
joinby judgeid day using "Judge\QJPS_judge_ProxData.dta"; 
rename day sentdate;

*merge in district characteristics by district; 
sort district; 
joinby district using "District\QJPS_KansasDistrictCharacteristics.dta";

*merge in data on whether judge was challenged; 
*variable challenged=1 if a judge (in a partisan district) is challenged during that term; 
sort judgeid sentdate; 
joinby judgeid sentdate using "Judge\QJPS_judgeid_sentdate_whetherjudgechallenged.dta";

#delimit;
regress totpris gpres0_pris grid1 grid2 addcount pso firearm v_govoff v_child 
	  appcouns pleabarg nonwhite male hispan age partisan elecprox 
	  c_assault c_crimthreat c_robbery c_sex c_theft c_burglary 
	  y_1 y_2 y_3 y_4 y_5 y_6 y_7; 
predict phat if e(sample);
drop if phat == .;
drop phat;

*Generate grid variable;
gen grid = 3;
replace grid = 2 if grid2 == 1;
replace grid = 1 if grid1 == 1;

rename gpres0_pris gpris0;

keep prison totpris partisan district gpris0 grid addcount pso firearm v_govoff v_child appcouns pleabarg 
     c_assault c_crimthreat c_robbery c_sex c_theft c_burglary year male hispan nonwhite 
     age elecprox challenged year;

/***************************************
** Delete observations for which no  **
** exact matches exist in treatment  **
** and control groups                **
***************************************/

egen matchgrp = group(gpris0 grid addcount firearm v_govoff v_child appcouns 
			pleabarg nonwhite male hispan c_assault c_crimthreat c_robbery c_sex c_theft c_burglary year);
sort matchgrp;
egen maxpart=max(partisan), by(matchgrp);
egen minpart=min(partisan), by(matchgrp);
drop if minpart == maxpart;
drop matchgrp;
egen matchgrp = group(gpris0 grid addcount pso firearm v_govoff v_child appcouns pleabarg nonwhite 
	         male hispan c_assault c_crimthreat c_robbery c_sex c_theft c_burglary year);
drop maxpart minpart;
sort matchgrp;
gen obno=_n;
save "QJPSkansasmatch.dta", replace;
* Delete observations in which a challenge occurred ;
drop if challenged == 1;
save "QJPSkansasmatch_uc.dta", replace;
clear;

/* Generate data for 40/60 analysis */
use "QJPSkansasmatch.dta";
/*19 districts, 8 are partisan*/
keep if district == 1| district == 2| district == 4| district == 5| district == 6| district == 8| 
        district == 9| district == 11| district == 12| district == 16| district == 18| district == 20| 
        district == 22|  district == 23| district == 24| district == 26| district == 29| district == 30|
	  district == 31;
save "QJPSkansasmatch20.dta", replace;
drop if challenged == 1;
save "QJPSkansasmatch20_uc.dta", replace;
clear;

/* Generate data for 44/56 analysis */
use "QJPSkansasmatch.dta";
/* 10 districts, four partisan */
keep if district == 1 | district == 2 | district == 11 | district == 18 | district == 30 | district == 29 |
	  district == 4 | district == 16| district == 6 | district == 26 ;
save "QJPSkansasmatch12.dta", replace;
drop if challenged == 1;
save "QJPSkansasmatch12_uc.dta", replace; 

/* Generate data for 47/53 analysis */
use "QJPSkansasmatch.dta";
/* 5 districts, 1 partisan */
keep if district == 1 | district == 2 | district == 11 | district == 18 | district == 30;
save "QJPSkansasmatch6.dta", replace;
drop if challenged == 1;
save "QJPSkansasmatch6_uc.dta", replace; 








****************************************************************************************










