#########################################################################
## QJPS_Main_matching_analysis.R						     ##
## Conducts the matching analysis found in Table 4, columns 1-4        ##
## This version: February 12, 2007
#########################################################################
sink("C:/Documents and Settings/Sanford Gordon/My Documents/research/primary/criminal justice/trial judges/kansas/matching/logfiles/QJPS_ksmatching.log")
library(foreign)
library(Matching)
#Generate list of district matches
print ("Use genetic matching to compile a list of district matches", quote=FALSE)
set.seed(10242004)
distchar <- as.data.frame(read.dta("C:/Documents and Settings/Sanford Gordon/My Documents/research/primary/criminal justice/trial judges/kansas/matching/District/QJPS_KansasDistrictCharacteristics.dta"))
attach(distchar)
Tr <-partisan
X <-cbind(crimerate,urbanrate,nwrate,edscale,presd00prop,propblack,popdens,medianhhinc,turnoutpres00,sctyesprop)
genout_d<-GenMatch(Tr=Tr,X=X,estimand="ATT",M=1,loss=1,pop.size=2500,unif.seed=10242004,int.seed=41870)
matchout_d<-Match(Tr=Tr,X=X,estimand="ATT",M=1,Weight.matrix=genout_d)
mb_d<-MatchBalance(Tr~crimerate+urbanrate+nwrate+edscale+presd00prop+propblack+popdens+medianhhinc+turnoutpres00+sctyesprop,nboots=500,match.out=matchout_d)
clust<-rep(0,times=length(Tr))
cldata<-cbind(district,partisan,clust)
for (i in 1:length(Tr)) {
	if (cldata[i,2]== 0) {
		if (sum(matchout_d$index.control==i)>0) {
			cldata[i,3]<-cldata[i,1]
		}
		else {
			cldata[i,3]<-0
		}
	}
	else {
		tempind<-which(matchout_d$index.treated==i)
		cldata[i,3]<-matchout_d$index.control[tempind]		
	}
}
detach(distchar)

#############################################
print("Here is the full list of district matches", quote = FALSE)
#############################################
matchout_d$index.treated
matchout_d$index.control

#######################################################################
print("Conduct analysis with all data, including challenged partisan judges", quote = FALSE)
#######################################################################
ksc <- as.data.frame(read.dta("C:/Documents and Settings/Sanford Gordon/My Documents/research/primary/criminal justice/trial judges/kansas/matching/QJPSkansasmatch.dta"))
attach(ksc)
Y1<-prison
Y2<-totpris
Tr<-partisan
#First, analysis without district-level matching
X<-cbind(gpris0,grid,addcount,firearm,v.govoff,v.child,appcouns,pleabarg,c.assault,c.crimthreat,c.robbery,c.sex,c.theft,c.burglary,year,male,hispan,nonwhite,age)
exact<-c(rep(1,times=ncol(X)-1),0)
cal  <-c(rep(0,times=ncol(X)-1),0.3)

print("********************Table 4, column (1) results********************", quote=FALSE)
matchout.pris.all.nd<-Match(Y=Y1,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.pris.all.nd)
matchout.totpris.all.nd<-Match(Y=Y2,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.totpris.all.nd)
mb.all.nd<-MatchBalance(Tr~age,nboots=500,match.out=matchout.totpris.all.nd)

#Now, analysis with district-level matching
cluster<-rep(0,times=length(obno))
for (i in 1:length(obno)) {
	cluster[i]<- cldata[district[i],3]
}
X<-cbind(gpris0,grid,addcount,firearm,v.govoff,v.child,appcouns,pleabarg,c.assault,c.crimthreat,c.robbery,c.sex,c.theft,c.burglary,year,male,hispan,nonwhite,cluster,age)
cal  <-c(rep(0,times=ncol(X)-1),0.2)
exact<-c(rep(1,times=ncol(X)-1),0)

print("********************Table 4, column (3) results********************", quote=FALSE)
matchout.pris.all.d<-Match(Y=Y1,Tr=Tr,X=X,exact=exact,caliper=cal,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.pris.all.d)
matchout.totpris.all.d<-Match(Y=Y2,Tr=Tr,X=X,exact=exact,caliper=cal,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.totpris.all.d)
mb.all.d<-MatchBalance(Tr~age,nboots=500,match.out=matchout.totpris.all.d)
detach(ksc)

#######################################################################
print("Conduct analysis with all data, excluding challenged partisan judges", quote=FALSE)
#######################################################################
ksc <- as.data.frame(read.dta("C:/Documents and Settings/Sanford Gordon/My Documents/research/primary/criminal justice/trial judges/kansas/matching/QJPSkansasmatch_uc.dta"))
attach(ksc)
Y1<-prison
Y2<-totpris
Tr<-partisan
#First, analysis without district-level matching
X<-cbind(gpris0,grid,addcount,firearm,v.govoff,v.child,appcouns,pleabarg,c.assault,c.crimthreat,c.robbery,c.sex,c.theft,c.burglary,year,male,hispan,nonwhite,age)
exact<-c(rep(1,times=ncol(X)-1),0)
cal  <-c(rep(0,times=ncol(X)-1),0.3)

print("********************Table 4, column (2) results********************", quote=FALSE)
matchout.pris.uc.nd<-Match(Y=Y1,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.pris.uc.nd)
matchout.totpris.uc.nd<-Match(Y=Y2,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.totpris.uc.nd)
mb.uc.nd<-MatchBalance(Tr~age,nboots=500,match.out=matchout.totpris.uc.nd)
#Now, analysis with district-level matching
cluster<-rep(0,times=length(obno))
for (i in 1:length(obno)) {
	cluster[i]<- cldata[district[i],3]
}
X<-cbind(gpris0,grid,addcount,firearm,v.govoff,v.child,appcouns,pleabarg,c.assault,c.crimthreat,c.robbery,c.sex,c.theft,c.burglary,year,male,hispan,nonwhite,cluster,age)
cal  <-c(rep(0,times=ncol(X)-1),0.25)
exact<-c(rep(1,times=ncol(X)-1),0)

print("********************Table 4, column (4) results********************", quote=FALSE)
matchout.pris.uc.d<-Match(Y=Y1,Tr=Tr,X=X,exact=exact,caliper=cal,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.pris.uc.d)
matchout.totpris.uc.d<-Match(Y=Y2,Tr=Tr,X=X,exact=exact,caliper=cal,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.totpris.uc.d)
mb.uc.d<-MatchBalance(Tr~age,nboots=500,match.out=matchout.totpris.uc.d)
detach(ksc)

#######################################################################
print("Conduct analysis with all 40-60 data", quote=FALSE)
#######################################################################
ksc <- as.data.frame(read.dta("C:/Documents and Settings/Sanford Gordon/My Documents/research/primary/criminal justice/trial judges/kansas/matching/QJPSkansasmatch20.dta"))
attach(ksc)
Y1<-prison
Y2<-totpris
Tr<-partisan
X<-cbind(gpris0,grid,addcount,firearm,v.govoff,v.child,appcouns,pleabarg,c.assault,c.crimthreat,c.robbery,c.sex,c.theft,c.burglary,year,male,hispan,nonwhite,age)
exact<-c(rep(1,times=ncol(X)-1),0)
cal  <-c(rep(0,times=ncol(X)-1),0.2)
print("******************Table 4, column (5) results*****************", quote=FALSE)
matchout.pris.20.nd<-Match(Y=Y1,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.pris.20.nd)
matchout.totpris.20.nd<-Match(Y=Y2,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.totpris.20.nd)
mb.20.nd<-MatchBalance(Tr~age,nboots=500,match.out=matchout.totpris.20.nd)
detach(ksc)

#############################################################################
print("Conduct analysis with all 40-60 data, excluding partisan challenged judges", quote=FALSE)
#############################################################################
ksc <- as.data.frame(read.dta("C:/Documents and Settings/Sanford Gordon/My Documents/research/primary/criminal justice/trial judges/kansas/matching/QJPSkansasmatch20_uc.dta"))
attach(ksc)
Y1<-prison
Y2<-totpris
Tr<-partisan
X<-cbind(gpris0,grid,addcount,firearm,v.govoff,v.child,appcouns,pleabarg,c.assault,c.crimthreat,c.robbery,c.sex,c.theft,c.burglary,year,male,hispan,nonwhite,age)
exact<-c(rep(1,times=ncol(X)-1),0)
cal  <-c(rep(0,times=ncol(X)-1),0.2)
print("*************Table 4, column (6) results*******************", quote=FALSE)
matchout.pris.20.uc.nd<-Match(Y=Y1,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.pris.20.uc.nd)
matchout.totpris.20.uc.nd<-Match(Y=Y2,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.totpris.20.uc.nd)
mb.20.uc.nd<-MatchBalance(Tr~age,nboots=500,match.out=matchout.totpris.20.uc.nd)
detach(ksc)

#######################################################################
print("Conduct analysis with all 44-56 data", quote=FALSE)
#######################################################################
ksc <- as.data.frame(read.dta("C:/Documents and Settings/Sanford Gordon/My Documents/research/primary/criminal justice/trial judges/kansas/matching/QJPSkansasmatch12.dta"))
attach(ksc)
Y1<-prison
Y2<-totpris
Tr<-partisan
X<-cbind(gpris0,grid,addcount,firearm,v.govoff,v.child,appcouns,pleabarg,c.assault,c.crimthreat,c.robbery,c.sex,c.theft,c.burglary,year,male,hispan,nonwhite,age)
exact<-c(rep(1,times=ncol(X)-1),0)
cal  <-c(rep(0,times=ncol(X)-1),0.2)
matchout.pris.12.nd<-Match(Y=Y1,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.pris.12.nd)
matchout.totpris.12.nd<-Match(Y=Y2,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.totpris.12.nd)
mb.12.nd<-MatchBalance(Tr~age,nboots=500,match.out=matchout.totpris.12.nd)
detach(ksc)

#############################################################################
print("Conduct analysis with all 44-56 data, excluding partisan challenged judges", quote=FALSE)
#############################################################################
ksc <- as.data.frame(read.dta("C:/Documents and Settings/Sanford Gordon/My Documents/research/primary/criminal justice/trial judges/kansas/matching/QJPSkansasmatch12_uc.dta"))
attach(ksc)
Y1<-prison
Y2<-totpris
Tr<-partisan
X<-cbind(gpris0,grid,addcount,firearm,v.govoff,v.child,appcouns,pleabarg,c.assault,c.crimthreat,c.robbery,c.sex,c.theft,c.burglary,year,male,hispan,nonwhite,age)
exact<-c(rep(1,times=ncol(X)-1),0)
cal  <-c(rep(0,times=ncol(X)-1),0.2)
matchout.pris.12.uc.nd<-Match(Y=Y1,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.pris.12.uc.nd)
matchout.totpris.12.uc.nd<-Match(Y=Y2,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.totpris.12.uc.nd)
mb.12.uc.nd<-MatchBalance(Tr~age,nboots=500,match.out=matchout.totpris.12.uc.nd)
detach(ksc)

#######################################################################
print("Conduct analysis with all 47-53 data", quote=FALSE)
#######################################################################
ksc <- as.data.frame(read.dta("C:/Documents and Settings/Sanford Gordon/My Documents/research/primary/criminal justice/trial judges/kansas/matching/QJPSkansasmatch6.dta"))
attach(ksc)
Y1<-prison
Y2<-totpris
Tr<-partisan
X<-cbind(gpris0,grid,addcount,firearm,v.govoff,v.child,appcouns,pleabarg,c.assault,c.crimthreat,c.robbery,c.sex,c.theft,c.burglary,year,male,hispan,nonwhite,age)
exact<-c(rep(1,times=ncol(X)-1),0)
cal  <-c(rep(0,times=ncol(X)-1),0.2)
matchout.pris.6.nd<-Match(Y=Y1,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.pris.6.nd)
matchout.totpris.6.nd<-Match(Y=Y2,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.totpris.6.nd)
mb.6.nd<-MatchBalance(Tr~age,nboots=500,match.out=matchout.totpris.6.nd)
detach(ksc)

#############################################################################
print("Conduct analysis with all 47-53 data, excluding partisan challenged judges", quote=FALSE)
#############################################################################
ksc <- as.data.frame(read.dta("C:/Documents and Settings/Sanford Gordon/My Documents/research/primary/criminal justice/trial judges/kansas/matching/QJPSkansasmatch6_uc.dta"))
attach(ksc)
Y1<-prison
Y2<-totpris
Tr<-partisan
X<-cbind(gpris0,grid,addcount,firearm,v.govoff,v.child,appcouns,pleabarg,c.assault,c.crimthreat,c.robbery,c.sex,c.theft,c.burglary,year,male,hispan,nonwhite,age)
exact<-c(rep(1,times=ncol(X)-1),0)
cal  <-c(rep(0,times=ncol(X)-1),0.2)
matchout.pris.6.uc.nd<-Match(Y=Y1,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.pris.6.uc.nd)
matchout.totpris.6.uc.nd<-Match(Y=Y2,Tr=Tr,X=X,caliper=cal,exact=exact,M=1,estimand="ATT",distance.tolerance=1e-8)
summary(matchout.totpris.6.uc.nd)
mb.6.uc.nd<-MatchBalance(Tr~age,nboots=500,match.out=matchout.totpris.6.uc.nd)
detach(ksc)

sink()
