library(anominate)
library(pscl)
library(foreign)
library(ggplot2)
library(directlabels)
library(dplyr)
#rm(list = ls())
mac.name<-read.csv("/Applications/Stata/machine_name.txt")
setwd(paste(mac.name[1,2],"/Research/Primary/MadisonianRepublic/Polarizing policies/",sep=""))

multiplot <- function(..., plotlist=NULL, file, cols=1, layout=NULL) {
  library(grid)
  # Make a list from the ... arguments and plotlist
  plots <- c(list(...), plotlist)
  numPlots = length(plots)
  # If layout is NULL, then use 'cols' to determine layout
  if (is.null(layout)) {
    # Make the panel
    # ncol: Number of columns of plots
    # nrow: Number of rows needed, calculated from # of cols
    layout <- matrix(seq(1, cols * ceiling(numPlots/cols)),
                     ncol = cols, nrow = ceiling(numPlots/cols))
  }
  
  if (numPlots==1) {
    print(plots[[1]])
    
  } else {
    # Set up the page
    grid.newpage()
    pushViewport(viewport(layout = grid.layout(nrow(layout), ncol(layout))))
    
    # Make each plot, in the correct location
    for (i in 1:numPlots) {
      # Get the i,j matrix positions of the regions that contain this subplot
      matchidx <- as.data.frame(which(layout == i, arr.ind = TRUE))
      
      print(plots[[i]], vp = viewport(layout.pos.row = matchidx$row,
                                      layout.pos.col = matchidx$col))
    }
  }
}
#################Estimate Ideal Points; Bill and Status Quo Locations; and other Parameters####################
data(sen111)
sen111_anom <- anominate(sen111, dims=1, polarity=2, nsamp=60000, thin=10,burnin=0, random.starts=FALSE, verbose=TRUE)
traceplot.anominate(sen111_anom)

################ Express utility function as an infinite Taylor series expansion with second-through infinity terms scaled by alpha#################
u<-function(x,x.hat,alpha=1,beta=1,tol=1e-7,w=1/2){
  d1<- beta+beta*(-1/2*w^2*(x.hat-x)^2)
  i<-2
  d2sum<-0
  d2sum.old<-1
  while(abs(d2sum-d2sum.old)>tol)  {
    if(i==2){
      d2sum <- alpha*beta*(-1/2*w^2*(x.hat-x)^2)^i/factorial(i)
    } else{
      d2sum.old <-d2sum
      d2sum <- d2sum + alpha*beta*(-1/2*w^2*(x.hat-x)^2)^i/factorial(i)
    }
    i<-i+1
  }
  d1+d2sum
}

################ Express marginal utility as an infinite Taylor series expansion with second-through infinity terms scaled by alpha#################
marg.util <-function(x.hat,alpha=1,beta=1,x,tol=1e-7,w=1/2){
  #estimate the primary component
  d1<- beta*w^2*(x.hat-x)
  #estimate the infinite series for the secondary component
  i<-2
  d2sum<-0
  d2sum.old<-1
  while(abs(d2sum-d2sum.old)>tol)  {
    if(i==2){
        d2sum <- -2*alpha*beta*(-w^2*(x.hat-x)^2/2)^i*i/((x.hat-x)*factorial(i))
    } else{
        d2sum.old <-d2sum
        d2sum <- d2sum + -2*alpha*beta*(-w^2*(x.hat-x)^2/2)^i*i/((x.hat-x)*factorial(i))
    }
  i<-i+1
  }
  return(d1+d2sum)
}

################Take the output from the alpha nominate routine, and for one iteration calculate RP.minus and RP.plus###############
RP.minus<-function(anominate.object,iter,x){
  lowdemanders.i<- as.vector(subset(as.matrix(anominate.object$legislators[[1]])[i,],as.matrix(anominate.object$legislators[[1]])[i,]<x))
  alpha.i <- anominate.object$alpha[i]
  beta.i <-anominate.object$beta[1]
  rpm.vec<- - unlist(lapply(lowdemanders.i,FUN=marg.util,alpha=alpha.i,beta=beta.i,x=x))
  return(sum(rpm.vec))
}
 
RP.plus<-function(anominate.object,iter,x){
  highdemanders.i<- as.vector(subset(as.matrix(anominate.object$legislators[[1]])[i,],as.matrix(anominate.object$legislators[[1]])[i,]>x))
  alpha.i <- anominate.object$alpha[i]
  beta.i <-anominate.object$beta[1]
  rpm.vec<- unlist(lapply(highdemanders.i,FUN=marg.util,alpha=alpha.i,beta=beta.i,x=x))
  return(sum(rpm.vec))
} 


##############Functions to calculate column and row percentiles###################
col.pctiles<-function(x,q=0.5){
  k<-ncol(x)
  result<-rep(NA,k)
  for(j in 1:k){
    result[j]<-quantile(x[,j],probs=q)
  }
  return(result)
}

row.pctiles<-function(x,q=0.5){
  n<-nrow(x)
  result<-rep(NA,n)
  for(i in 1:n){
    result[i]<-quantile(x[i,],probs=q)
  }
  return(result)
}


##########Calculate utilities for policy x associated with a vector of legislators from an MCMC object###
u.vec<-function(x,anominate.object,iter,tol=1e-7,w=1/2){
  alpha<-anominate.object$alpha[iter]
  beta<-anominate.object$beta[iter]
  x.hat.vec<-as.matrix(anominate.object$legislators[[1]])[iter,]
  n<- length(x.hat.vec)
  u.vec.out <-rep(NA,n)
  for (i in 1:n){
    u.vec.out[i]<-u(x=x,x.hat=x.hat.vec[i],alpha=alpha,beta=beta,tol=tol,w=w)
  }
  return(u.vec.out)
}

##########Social Welfare function##############
sw<-function(x,anominate.object,iter,tol=1e-7,w=1/2){
  uv<- u.vec(x=x,anominate.object=anominate.object,iter=iter,tol=tol,w=w)
  -sum(uv)
  }
  
##########Social Welfare Maximizing Policy##############
sw.max<-function(anominate.object,iter,tol=1e-7,w=1/2){
  optim(0,fn=sw,anominate.object=anominate.object,iter=iter,tol=tol,w=w,lower=-1,upper=1,method="Brent")$par
}



############Nash Transfer Measure #######################################################
##Takes two policies p and q and calculates a vector of transfers necessary 
##to move from q to p under Nash bargaining
transfer.qp<-function(p,q,anominate.object,iter){
  n<-ncol(as.matrix(anominate.object$legislators[[1]]))
  #Calculate vector of utilities associated with policies q and p
  u.q<-u.vec(q,anominate.object=anominate.object,iter=iter)
  u.p<-u.vec(p,anominate.object=anominate.object,iter=iter)
  k.vec<-as.vector(u.p-u.q)
  sum.all.ks<-sum(k.vec)
  sum.k.j<-sum.all.ks-k.vec
  t.vec<-1/n*(sum.k.j-(n-1)*k.vec)
  #Total Transfers
  return(sum(t.vec*(t.vec>0)))
}

###########Take it or leave it #############################################
##Takes two policies p and q and calculates vector of utility differences
delta.u.vec<-function(p,q,x.hat.vec,alpha,beta,tol=1e-7,w=1/2){
  n<- length(x.hat.vec)
  delta.out <-rep(NA,n)
  for (i in 1:n){
    u.p<-u(x=p,x.hat=x.hat.vec[i],alpha=alpha,beta=beta,tol=tol,w=w)
    u.q<-u(x=q,x.hat=x.hat.vec[i],alpha=alpha,beta=beta,tol=tol,w=w)
    delta.out[i]<-u.p-u.q
  }
  return(delta.out)
}

##Identify cutpoint of two policies p and q, determine the size of take it or leave it offers required to a threshold level of support theta
transfer.tioli<-function(p,q,x.hat.vec,alpha,beta,theta=0.5,tol=1e-7,w=1/2){
  n<- length(x.hat.vec)
  delta.vec<-delta.u.vec(p=p,q=q,x.hat.vec=x.hat.vec,alpha=alpha,beta=beta,tol=tol,w=w)
  initial.supporters<-sum(as.vector(delta.vec >= 0))/n
  if(initial.supporters >= theta){
    return(0)
  } else {
    extra.supporters.needed<- n*(theta - initial.supporters)
    initial.opponent.vec<- sort(abs(subset(delta.vec,delta.vec < 0)))
    return(sum(initial.opponent.vec[1:extra.supporters.needed]))
  }
}

#Drop Burn-in observations in the alpha-nominate object
sen111_anom$legislators[[1]]<-(sen111_anom$legislators[[1]])[1001:6000,]
sen111_anom$alpha<-sen111_anom$alpha[1001:6000]
sen111_anom$beta<-sen111_anom$beta[1001:6000]

x.hat.vec.all<-colMeans(as.matrix(sen111_anom$legislators[[1]]))
x.hat.vec<-subset(x.hat.vec.all,!names(x.hat.vec.all) %in% c("OBAMA (D USA)","COONS (D DE)","MARTINEZ (R FL)","KIRK (R IL)","KIRK (D MA)","GOODWIN (D WV)","MANCHIN (D WV)","SPECTER (R PA)"))

alpha<-mean(as.vector(sen111_anom$alpha))
beta<-mean(as.vector(sen111_anom$beta))
p.vec<-seq(from=-2.5,to=2.5,by=0.1)
q.vec<-seq(from=-2.5,to=2.5,by=0.1)
length<-length(p.vec)
z<-rep(NA,length^2)
dim(z)<-c(length,length)
result<-rep(NA,3*length^2)
dim(result)<-c(length^2,3)
colnames(result)<-c("x","y","z")
#Index status quos with i, proposals with j
for (i in 1:length){
  for (j in 1:length){
    z[i,j]<- transfer.tioli(p.vec[j],q.vec[i],x.hat.vec=x.hat.vec,alpha=alpha,beta=beta,theta=1)-transfer.tioli(p.vec[j],q.vec[i],x.hat.vec=x.hat.vec,alpha=alpha,beta=beta,theta=0.6)
    result[length*(i-1)+j,1]<-q.vec[i]
    result[length*(i-1)+j,2]<-p.vec[j]
    result[length*(i-1)+j,3]<-z[i,j]
  }
}
pdf(file="contour_map.pdf",height=8,width=10)
par(family="serif")
lb<- -2.5
ub<- 2.5
plot(NA,NA,xlim=c(lb,ub),ylim=c(lb,ub),ylab="Proposal, x",xlab=expression(paste("Status Quo, ",x^0)),bg="gray",cex.lab=1.5,cex.axis=1.5)
u <- par("usr") # The coordinates of the plot area
rect(u[1], u[3], u[2], u[4], col="grey90", border=NA)
mesh<-9
x0.vec<-rep(lb,mesh)
x1.vec<-rep(ub,mesh)
y0.vec<-c(-4,-3,-2,-1,0,1,2,3,4)+lb
y1.vec<-c(-4,-3,-2,-1,0,1,2,3,4)+ub
segments(x0=x0.vec,y0=y0.vec,x1=x1.vec,y1=y1.vec,lty="solid",lwd=1,col="white")
y0.vec<-c(-4,-3,-2,-1,0,1,2,3,4)-lb
y1.vec<-c(-4,-3,-2,-1,0,1,2,3,4)-ub
segments(x0=x0.vec,y0=y0.vec,x1=x1.vec,y1=y1.vec,lty="solid",lwd=1,col="white")
par(new=TRUE)
contour(p.vec,q.vec,z,xlim=c(lb,ub),ylim=c(lb,ub),ylab="",xlab="",lwd=2,yaxt="n",xaxt="n")
par(new=TRUE)
rc<-as.data.frame(read.csv("https://voteview.com/static/data/out/rollcalls/S111_rollcalls.csv"))
rc.fp<-subset(rc,vote_result=="Bill Passed" & nominate_mid_1!=0)
rc.fp.h<-subset(rc.fp,grepl("HR",bill_number))
rc.fp.s<-subset(rc.fp,grepl("S",bill_number))
votes.touse<-paste("Vote",rc.fp$rollnumber)
votes.touse.h<-paste("Vote",rc.fp.h$rollnumber)
votes.touse.s<-paste("Vote",rc.fp.s$rollnumber)
x<-colMeans(as.matrix(sen111_anom$nay.locations)[,votes.touse])
y<-colMeans(as.matrix(sen111_anom$yea.locations)[,votes.touse])
x.h<-colMeans(as.matrix(sen111_anom$nay.locations)[,votes.touse.h])
y.h<-colMeans(as.matrix(sen111_anom$yea.locations)[,votes.touse.h])
x.s<-colMeans(as.matrix(sen111_anom$nay.locations)[,votes.touse.s])
y.s<-colMeans(as.matrix(sen111_anom$yea.locations)[,votes.touse.s])
labels<-rc.fp$bill_number
labels.h<-rc.fp.h$bill_number
labels.s<-rc.fp.s$bill_number
text(x=unlist(x.h),y=unlist(y.h),labels=labels.h,cex=1)
text(x=unlist(x.s),y=unlist(y.s),labels=labels.s,cex=1)

dev.off()

rc.fp.h<-subset(rc.fp,grepl("HR",bill_number))

vfont = c("serif","plain")
vfont=c("serif","italic")


########Make RP.minus matrix, an n x k vector in which each column is the implied RP+ for a vector of x's, and each row is for a single iteration.
x.vec<-seq(from=-1,to=1,by=0.05)
num.policies<-length(x.vec)
iters<-nrow(as.matrix(sen111_anom$legislators[[1]]))
RP.plus.output<-rep(NA,num.policies*iters)
dim(RP.plus.output)<-c(iters,num.policies)
RP.minus.output<-RP.plus.output
RP.output <- RP.plus.output
transfer.output<-RP.output
swmax.output<-rep(NA,iters)


#Calculate scalar resistance potential and transfer potential measures
for(i in 1:iters){ 
  p.max<-sw.max(anominate.object=sen111_anom,iter=i)
  swmax.output[i]<- p.max
  for(j in 1:num.policies){
    x<-x.vec[j]
    RPP<-RP.plus(sen111_anom,iter=i,x=x)
    RPM<-RP.minus(sen111_anom,iter=i,x=x)
    RP <- max(RPP,RPM)
    RP.plus.output[i,j]<-RPP
    RP.minus.output[i,j]<-RPM
    RP.output[i,j]<-RP
    transfer.output[i,j]<-transfer.qp(p.max,x,sen111_anom,iter=i)
  }
}
d<-as.data.frame(cbind(x.vec,colMeans(RP.output),col.pctiles(RP.output,q=0.025),col.pctiles(RP.output,q=0.975)))
g.RP<-ggplot(d,aes(x=x.vec,y=V2))+geom_ribbon(aes(ymin=V3,ymax=V4), fill = "grey70")+geom_line()+geom_vline(xintercept=-0.3744967)+geom_vline(xintercept=-0.04307053)+
  labs(y=expression(paste("Marginal Resistance Potential, ",italic(mRP(x^0)))),x = expression(paste("Status quo policy, ", x^0)))+theme(text = element_text(size=20,family="serif"))+
  annotate("text", x = -.3, y = 121, label = "paste(hat(x)[m])",parse=TRUE,size=6,family="serif")+annotate("text", x = 0.01, y = 121, label = '"x*"',parse=TRUE,size=6,family="serif")+
  ggtitle("Marginal Resistance Potential")
d2<-as.data.frame(cbind(x.vec,colMeans(transfer.output),col.pctiles(transfer.output,q=0.025),col.pctiles(transfer.output,q=0.975)))
g.UT<-ggplot(d2,aes(x=x.vec,y=V2))+geom_ribbon(aes(ymin=V3,ymax=V4), fill = "grey70")+geom_line()+geom_vline(xintercept=-0.3744967)+geom_vline(xintercept=-0.04307053)+
  labs(y=expression(paste("Nash Transfer Potential, ",italic(NTP(x^0)))),x = expression(paste("Status quo policy, ", x^0)))+theme(text = element_text(size=20,family="serif"))+
  annotate("text", x = -.3, y = -5, label = "paste(hat(x)[m])",parse=TRUE,size=6,family="serif")+annotate("text", x = 0.01, y = -5, label = '"x*"',parse=TRUE,size=6,family="serif")+
  ggtitle("Nash Transfer Potential")

pdf(file="SQ_functions.pdf",height=7,width=14)
multiplot(g.UT,g.RP, cols=2)
dev.off()


pdf(file="SQ_functions.pdf",height=7,width=14)
multiplot(g.UT,g.RP, cols=2)
dev.off()


x.hat.vec.all<-colMeans(as.matrix(sen111_anom$legislators))
x.hat.vec<-subset(x.hat.vec.all,!names(x.hat.vec.all) %in% c("OBAMA (D USA)","COONS (D DE)","MARTINEZ (R FL)","KIRK (R IL)","KIRK (D MA)","GOODWIN (D WV)","MANCHIN (D WV)","SPECTER (R PA)"))
x.data<-as.data.frame(x.hat.vec)
colnames(x.data)<-c("anom1")

x.hat.dems<-as.data.frame(x.hat.vec[grep("\\(D ",as.vector(names(x.hat.vec)))])
colnames(x.hat.dems)<-c("anom1")
x.hat.gop<-as.data.frame(x.hat.vec[grep("\\(R ",as.vector(names(x.hat.vec)))])
colnames(x.hat.gop)<-c("anom1")


g1<-ggplot()+geom_density(data=x.hat.dems,aes(anom1),colour="blue",trim=FALSE,fill="blue",alpha=0.1)+
geom_density(data=x.hat.gop,aes(anom1),colour="red",trim=FALSE,fill="red",alpha=0.1)+labs(y="Density",x="Alpha-NOMINATE Score")+
  theme(text = element_text(size=20,family="serif"))
lb<-as.matrix(col.pctiles(as.matrix(sen111_anom$legislators[[1]]),.025))
rownames(lb)<-colnames(as.matrix(sen111_anom$legislators[[1]]))
ub<-as.matrix(col.pctiles(as.matrix(sen111_anom$legislators[[1]]),.975))
rownames(ub)<-colnames(as.matrix(sen111_anom$legislators[[1]]))
bounds<-cbind(lb,ub)
d1<-merge(bounds,x.hat.vec.all,by="row.names",all.x=TRUE)
rownames(d1)<-d1[,1]
d1a<-d1[,2:4]
colnames(d1a)<-c("lb","ub","m")
d2<-as.matrix(sen111_anom$wnom.result$legislators$coord1D)
rownames(d2)<-rownames(sen111_anom$wnom.result$legislators)
colnames(d2)<-c("coord1D")
d<-as.data.frame(merge(d2,d1a,by="row.names",all.x=TRUE))
d<-subset(d,is.na(coord1D)==FALSE)
g2<-ggplot(d,aes(y=m,x=coord1D))+ geom_point(size=2)+geom_segment(aes(x=coord1D,y=lb,yend=ub,xend=coord1D))+
  theme(text = element_text(size=20,family="serif"))+labs(y="Alpha-NOMINATE",x="W-Nominate")
pdf(file="Nominate.pdf",height=7,width=14)
multiplot(g2,g1, cols=2)
dev.off()




###############Polarization simulation##################
u.quad<-function(x,x.hat.vec){
  -(x-x.hat.vec)^2
}

delta.u.vec.quad<-function(p,q,x.hat.vec){
  n<- length(x.hat.vec)
  delta.out <-rep(NA,n)
  for (i in 1:n){
    u.p<-u.quad(x=p,x.hat=x.hat.vec[i])
    u.q<-u.quad(x=q,x.hat=x.hat.vec[i])
    delta.out[i]<-u.p-u.q
  }
  return(delta.out)
}

transfer.tioli.quad<-function(p,q,x.hat.vec,theta=0.5){
  n<- length(x.hat.vec)
  delta.vec<-delta.u.vec.quad(p=p,q=q,x.hat.vec=x.hat.vec)
  initial.supporters<-sum(as.vector(delta.vec >= 0))/n
  if(initial.supporters >= theta){
    return(0)
  } else {
    extra.supporters.needed<- n*(theta - initial.supporters)
    initial.opponent.vec<- sort(abs(subset(delta.vec,delta.vec < 0)))
    return(sum(initial.opponent.vec[1:extra.supporters.needed]))
  }
}


compressions<-25
sims<-250
results<-rep(NA,compressions*sims*4)
dim(results)<-c(compressions*sims,4)
for (i in 1:compressions){
  d<-0.5- (i-1)*.015
  dem.vec<- seq(from=0.0,length.out=50,by=d/50)
  gop.vec<- seq(to=1,length.out=50,by=d/50)
  x.hat.vec<-c(dem.vec,gop.vec)
  for (n in 1:sims){
    r<-n+(i-1)*sims
    results[r,1]<-mean(gop.vec)-mean(dem.vec) 
    q<-runif(1)
    p<-runif(1,min=min(gop.vec),max=max(gop.vec))
    results[r,2]<-transfer.tioli.quad(p=p,q=q,x.hat.vec=x.hat.vec,theta=0.6)
    results[r,3]<-p
    results[r,4]<-q
  }
}
data.out<-as.data.frame(results)
colnames(data.out)<-c("polarization","aRP","p","q")
group.data.out<-group_by(data.out,polarization)
d2<-data.out %>% group_by(polarization) %>% filter(aRP == max(aRP))
d2<-as.data.frame(d2)

plot(y=results[,2],x=results[,1])
plot(y=d2$aRP,x=d2$polarization,type="l")
ggplot(d2)+geom_point(aes(y=aRP,x=polarization))

pdf(file="aRP_polarization.pdf",height=8,width=10)
ggplot()+geom_point(data=data.out,aes(y=aRP,x=polarization))+
theme(text = element_text(size=20,family="serif"))+labs(y="Absolute Resistance Potential (aRP)",x="Polarization")+geom_line(data=d2,aes(y=aRP,x=polarization),colour="blue")
dev.off()



